#!/bin/bash

if [ "$(id -u)" -gt 0 ]; then
	echo "poweroff needs to be run as root or using sudo"
	exit 1
elif [[ $(ps -p1 | grep -ic "init") -eq 1 ]]; then
		/usr/lib/sysvinit/poweroff $@;
elif [[ $(ps -p1 | grep -ic "runit") -eq 1 ]]; then
		sync && touch /run/initctl && /usr/lib/runit/shutdown $@;
elif [[ $(ps -p1 | grep -ic "s6-svscan") -eq 1 && -e /run/s6-rc ]]; then
		/usr/lib/s6-rc/poweroff $@;
elif [[ $(ps -p1 | grep -ic "s6-svscan") -eq 1 && -e /run/66 ]]; then
		/usr/lib/s6-66/poweroff $@;
else sync && touch /run/initctl && /usr/lib/sysvinit/poweroff &>/dev/null | /usr/lib/runit/shutdown &>/dev/null | /usr/lib/s6-rc/poweroff &>/dev/null | /usr/lib/s6-66/poweroff &>/dev/null

fi
