#!/bin/bash

if [ "$(id -u)" -gt 0 ]; then
	echo "shutdown needs to be run as root or using sudo"
	exit 1
elif [[ $(ps -p1 | grep -ic "init") -eq 1 ]]; then
		/usr/lib/sysvinit/shutdown $@;
elif [[ $(ps -p1 | grep -ic "runit") -eq 1 ]]; then
		sync && touch /run/initctl && /usr/lib/runit/shutdown $@;
elif [[ $(ps -p1 | grep -ic "s6-svscan") -eq 1 && -e /run/s6-rc ]]; then
		s6-linux-init-shutdown $@;
elif [[ $(ps -p1 | grep -ic "s6-svscan") -eq 1 && -e /run/66 ]]; then
		66-shutdown $@;
else sync && touch /run/initctl && /usr/lib/sysvinit/shutdown $@ &>/dev/null | /usr/lib/runit/shutdown $@ &>/dev/null | s6-linux-init-shutdown $@ &>/dev/null | 66-shutdown $@ &>/dev/null

fi
