#!/bin/bash

if [ "$(id -u)" -gt 0 ]; then
	echo "poweroff needs to be run as root or using sudo"
	exit 1
elif [[ $(ps -p1 | grep -ic "s6-svscan") -eq 1 && -e /run/s6-rc ]]; then
		/lib/s6-rc/poweroff $@;
elif [[ $(ps -p1 | grep -ic "s6-svscan") -eq 1 && -e /run/66 ]]; then
		/lib/s6-66/poweroff $@;
elif [[ $(ps -p1 | grep -ic "runit") -eq 1 ]]; then
		sync && touch /run/initctl && /lib/runit/shutdown $@;
elif [[ $(ps -p1 | grep -ic "openrc") -eq 1 ]]; then
		/lib/openrc/openrc-shutdown -p now;
elif [[ $(ps -p1 | grep -ic "init") -eq 1 ]]; then
		/lib/sysvinit/poweroff $@;
else sync && touch /run/initctl && /usr/lib/s6-rc/poweroff &>/dev/null | /usr/lib/s6-66/poweroff &>/dev/null | /usr/lib/runit/shutdown &>/dev/null | /usr/lib/openrc/openrc-shutdown -p now &>/dev/null | /usr/lib/sysvinit/poweroff &>/dev/null

fi
