#!/bin/bash

if [ "$(id -u)" -gt 0 ]; then
	echo "reboot needs to be run as root or using sudo"
	exit 1
elif [[ $(ps -p1 | grep -ic "s6-svscan") -eq 1 && -e /run/s6-rc ]]; then
		/usr/lib/s6-rc/reboot $@;
elif [[ $(ps -p1 | grep -ic "s6-svscan") -eq 1 && -e /run/66 ]]; then
		/usr/lib/s6-66/reboot $@;
elif [[ $(ps -p1 | grep -ic "runit") -eq 1 ]]; then
		sync && touch /run/initctl && /usr/lib/runit/runit-init 6;
elif [[ $(ps -p1 | grep -ic "openrc") -eq 1 ]]; then
		/usr/lib/openrc/openrc-shutdown -r now;
elif [[ $(ps -p1 | grep -ic "dinit") -eq 1 ]]; then
		/usr/lib/dinit/reboot $@;	
elif [[ $(ps -p1 | grep -ic "init") -eq 1 ]]; then
		/usr/lib/sysvinit/reboot $@;	
elif [[ $(ps -p1 | grep -ic "systemd") -eq 1 ]]; then
		/usr/lib/systemd/systemctl reboot $@;
else sync && touch /run/initctl && /lib/s6-rc/reboot &>/dev/null | /lib/s6-66/reboot &>/dev/null | /lib/runit/runit-init 6 &>/dev/null | /lib/openrc/openrc-shutdown -r now &>/dev/null | /lib/dinit/reboot &>/dev/null | /lib/sysvinit/reboot &>/dev/null | /lib/systemd/systemctl reboot &>/dev/null

fi
