#!/bin/bash

if [ "$(id -u)" -gt 0 ]; then
	echo "shutdown needs to be run as root or using sudo"
	exit 1
elif [[ $(ps -p1 | grep -ic "s6-svscan") -eq 1 && -e /run/s6-rc ]]; then
		s6-linux-init-shutdown $@;
elif [[ $(ps -p1 | grep -ic "s6-svscan") -eq 1 && -e /run/66 ]]; then
		66-shutdown $@;
elif [[ $(ps -p1 | grep -ic "runit") -eq 1 ]]; then
		sync && touch /run/initctl && /usr/lib/runit/shutdown $@;
elif [[ $(ps -p1 | grep -ic "openrc") -eq 1 ]]; then
		/usr/lib/openrc/openrc-shutdown $@;
elif [[ $(ps -p1 | grep -ic "dinit") -eq 1 ]]; then
		/usr/lib/dinit/shutdown $@;
elif [[ $(ps -p1 | grep -ic "init") -eq 1 ]]; then
		/usr/lib/sysvinit/shutdown $@;
elif [[ $(ps -p1 | grep -ic "systemd") -eq 1 ]]; then
		/usr/lib/systemd/systemd-shutdown $@;
else sync && touch /run/initctl && s6-linux-init-shutdown $@ &>/dev/null | 66-shutdown $@ &>/dev/null | /lib/runit/shutdown $@ &>/dev/null | /lib/openrc/openrc-shutdown $@ &>/dev/null | /lib/dinit/shutdown $@ &>/dev/null | /lib/sysvinit/shutdown $@ &>/dev/null | /lib/systemd/systemd-shutdown &>/dev/null

fi
