#!/bin/bash

[ "$UID" -eq 0 ] || exec sudo bash "$0" "$@"

if [ "$(id -u)" -gt 0 ]; then
	echo "poweroff needs to be run as root or using sudo"
	exit 1
elif [[ $(ps -p1 | grep -ic "s6-svscan") -eq 1 && -e /run/s6-rc ]]; then
		/usr/lib/s6-rc/poweroff $@ | /usr/sbin/poweroff $@;
elif [[ $(ps -p1 | grep -ic "s6-svscan") -eq 1 && -e /run/66 ]]; then
		/usr/lib/s6-66/poweroff $@ | /usr/sbin/poweroff $@;
elif [[ $(ps -p1 | grep -ic "runit") -eq 1 ]]; then
		sync && touch /run/initctl && /usr/lib/runit/shutdown $@ | /usr/sbin/shutdown $@;
elif [[ $(ps -p1 | grep -ic "openrc") -eq 1 ]] || ( [[ $(ps -p1 | grep -ic "init") -eq 1 ]] && [[ $(init --version | grep -ic "SysV" ) -eq 0 ]] && [[ $(init --version | grep -ic "Dinit" ) -eq 0 ]] ); then
		/usr/lib/openrc/openrc-shutdown -p now | /usr/sbin/openrc-shutdown -p now;
elif [[ $(ps -p1 | grep -ic "dinit") -eq 1 ]] || ( [[ $(ps -p1 | grep -ic "init") -eq 1 ]] && [[ $(init --version | grep -ic "Dinit") -eq 1 ]] ); then
		/usr/lib/dinit/shutdown $@ | /usr/sbin/shutdown $@;
elif [[ $(ps -p1 | grep -ic "init") -eq 1 ]] && [[ $(init --version | grep -ic "SysV") -eq 1 ]]; then
		/usr/lib/sysvinit/poweroff $@ | /usr/sbin/poweroff $@;
elif [[ $(ps -p1 | grep -ic "systemd") -eq 1 ]]; then
		/usr/lib/systemd/systemctl poweroff $@;
else sync && touch /run/initctl && /usr/sbin/poweroff $@ >/dev/null 2>&1 | /lib/s6-rc/poweroff $@ >/dev/null 2>&1 | /lib/s6-66/poweroff $@ >/dev/null 2>&1 | /lib/runit/shutdown $@; >/dev/null 2>&1 | /lib/openrc/openrc-shutdown -p now >/dev/null 2>&1 | /lib/dinit/shutdown $@; >/dev/null 2>&1 | /lib/sysvinit/poweroff $@; >/dev/null 2>&1 | /lib/systemd/systemctl poweroff $@; >/dev/null 2>&1

fi
