#!/bin/bash

[ "$UID" -eq 0 ] || exec sudo bash "$0" "$@"

if [ "$(id -u)" -gt 0 ]; then
	echo "reboot needs to be run as root or using sudo"
	exit 1
elif [[ $(ps -p1 | grep -ic "s6-svscan") -eq 1 && -e /run/s6-rc ]]; then
		/usr/lib/s6-rc/reboot $@ | /usr/sbin/reboot $@;
elif [[ $(ps -p1 | grep -ic "s6-svscan") -eq 1 && -e /run/66 ]]; then
		/usr/lib/s6-66/reboot $@ | /usr/sbin/reboot $@;
elif [[ $(ps -p1 | grep -ic "runit") -eq 1 ]]; then
		sync && touch /run/initctl && /usr/lib/runit/runit-init 6;
elif [[ $(ps -p1 | grep -ic "openrc") -eq 1 ]] || ( [[ $(ps -p1 | grep -ic "init") -eq 1 ]] && [[ $(init --version | grep -ic "SysV" ) -eq 0 ]] && [[ $(init --version | grep -ic "Dinit" ) -eq 0 ]] ); then
		/usr/lib/openrc/openrc-shutdown -r now | /usr/sbin/openrc-shutdown -r now;
elif [[ $(ps -p1 | grep -ic "dinit") -eq 1 ]] || ( [[ $(ps -p1 | grep -ic "init") -eq 1 ]] && [[ $(init --version | grep -ic "Dinit") -eq 1 ]] ); then
		/usr/lib/dinit/reboot $@ | /usr/sbin/reboot $@;
elif [[ $(ps -p1 | grep -ic "init") -eq 1 ]] && [[ $(init --version | grep -ic "SysV") -eq 1 ]]; then
		/usr/lib/sysvinit/reboot $@ | /usr/sbin/reboot $@;
elif [[ $(ps -p1 | grep -ic "systemd") -eq 1 ]]; then
		/usr/lib/systemd/systemctl reboot $@;
else sync && touch /run/initctl && /sbin/reboot $@ >/dev/null 2>&1 | /lib/s6-rc/reboot $@ >/dev/null 2>&1 | /lib/s6-66/reboot $@ >/dev/null 2>&1 | /lib/runit/runit-init 6 >/dev/null 2>&1 | /lib/openrc/openrc-shutdown -r now >/dev/null 2>&1 | /lib/dinit/reboot $@ >/dev/null 2>&1 | /lib/sysvinit/reboot $@ >/dev/null 2>&1 | /lib/systemd/systemctl reboot $@ >/dev/null 2>&1

fi
