#!/bin/bash

#~ [ "$UID" -eq 0 ] || exec sudo bash "$0" "$@"

if mountpoint -q /live/aufs; then
	#~ echo "Live/Frugal system detected... detecting init"
		if [ $(cat /proc/cmdline | grep -ic "init=/") -eq 0 ]; then
			#~ echo "Primary Live/Frugal init booted... detecting primary live init"
				if [ $(ps -p1 | grep -ic "runit") -eq 1 ]; then
					#~ echo "runit Live/Frugal system detected...  executing runlevel command..."
					/usr/lib/runit/runlevel $@;
					exit 0
				elif [ $(ps -p1 | grep -ic "s6-svscan") -eq 1 ] && [ -e /run/s6-rc ]; then
					echo "s6-rc Live/Frugal primary init detected...  Runlevels are not relevant for s6-rc..."
					exit 0
				elif [ $(ps -p1 | grep -ic "s6-svscan") -eq 1 ] && [ -e /run/66 ]; then
					echo "s6-66 Live/Frugal primary init detected...  Runlevels are not relevant for s6-66..."
					exit 0
				elif [ $(ps -p1 | grep -ic "openrc") -eq 1 ] || [ $(readlink -e /sbin/init | grep -ic "openrc") -eq 1 ]; then
					#~ echo "openrc Live/Frugal primary init detected...  executing runlevel command..."
					rc-status -r $@;
					exit 0
				elif [ $(ps -p1 | grep -ic "dinit") -eq 1 ] || [ $(/sbin/init --version | grep -ic "Dinit") -eq 1 ]; then
					echo "dinit Live/Frugal primary init detected...  Runlevels are not relevant for dinit..."
					exit 0
				elif [ $(ps -p1 | grep -ic "init") -eq 1 ] && [ $(/sbin/init --version | grep -ic "SysV") -eq 1 ]; then
					#~ echo "sysvinit Live/Frugal primary init detected...  executing runlevel command..."
					/usr/lib/sysvinit/runlevel $@;
					exit 0
				elif [ $(ps -p1 | grep -ic "systemd") -eq 1 ]; then
					#~ echo "systemd Live/Frugal primary init detected...  executing runlevel command..."
					/usr/lib/systemd/runlevel $@;
					exit 0
				else 
					echo "Strange... Cannot detect Live/Frugal primary init...  Will try to execute runlevel using bysybox... executing runlevel command..."
					sync && sleep 5 && /usr/bin/busybox runlevel -f;
					exit 1
				fi
		else
			#~ echo "cmdline Live/Frugal init booted... detecting live init"
				if [ $(ps -p1 | grep -ic "runit") -eq 1 ]; then
					#~ echo "runit Live/Frugal cmdline init detected...  executing runlevel command..."
					/usr/lib/runit/runlevel $@;
					exit 0
				elif [ $(ps -p1 | grep -ic "s6-svscan") -eq 1 ] && [ -e /run/s6-rc ]; then
					echo "s6-rc Live/Frugal cmdline init detected...  Runlevels are not relevant for s6-rc..."
					exit 0
				elif [ $(ps -p1 | grep -ic "s6-svscan") -eq 1 ] && [ -e /run/66 ]; then
					echo "s6-66 Live/Frugal cmdline init detected...  Runlevels are not relevant for s6-66..."
					exit 0
				elif [ $(cat /proc/cmdline | grep -ic "openrc") -eq 1 ]; then
					#~ echo "openrc Live/Frugal cmdline init detected...  executing runlevel command..."
					rc-status -r $@;
					exit 0
				elif [ $(cat /proc/cmdline | grep -ic "dinit") -eq 1 ]; then
					echo "dinit Live/Frugal cmdline init detected...  Runlevels are not relevant for dinit..."
					exit 0
				elif [ $(cat /proc/cmdline | grep -ic "sysvinit") -eq 1 ]; then
					#~ echo "sysvinit Live/Frugal cmdline init detected...  executing runlevel command..."
					/usr/lib/sysvinit/runlevel $@;
					exit 0
				elif [ $(ps -p1 | grep -ic "systemd") -eq 1 ]; then
					#~ echo "systemd Live/Frugal cmdline init detected...  executing runlevel command..."
					/usr/lib/systemd/runlevel $@;
					exit 0
				else 
					echo "Strange... Cannot detect Live/Frugal cmdline init...  Will try to execute runlevel using bysybox... executing runlevel command..."
					sync && sleep 5 && /usr/bin/busybox runlevel -f;
					exit 1
				fi	
		fi
else
	#~ echo "Installed system detected... detecting init"
		if [ $(cat /proc/cmdline | grep -ic "init=/") -eq 0 ]; then
			#~ echo "Primary init booted... detecting primary init"
				if [ $(ps -p1 | grep -ic "runit") -eq 1 ]; then
					#~ echo "runit primary init detected...  executing runlevel command..."
					/usr/lib/runit/runlevel $@;
					exit 0
				elif [ $(ps -p1 | grep -ic "s6-svscan") -eq 1 ] && [ -e /run/s6-rc ]; then
					echo "s6-rc primary init detected...  Runlevels are not relevant for s6-rc..."
					exit 0
				elif [ $(ps -p1 | grep -ic "s6-svscan") -eq 1 ] && [ -e /run/66 ]; then
					echo "s6-66 primary init detected...  Runlevels are not relevant for s6-66..."
					exit 0
				elif [ $(ps -p1 | grep -ic "openrc") -eq 1 ] || [ $(readlink -e /sbin/init | grep -ic "openrc") -eq 1 ]; then
					#~ echo "openrc primary init detected...  executing runlevel command..."
					rc-status -r $@;
					exit 0
				elif [ $(ps -p1 | grep -ic "dinit") -eq 1 ] || [ $(/sbin/init --version | grep -ic "Dinit") -eq 1 ]; then
					echo "dinit primary init detected...  Runlevels are not relevant for dinit..."
					exit 0
				elif [ $(ps -p1 | grep -ic "init") -eq 1 ] && [ $(/sbin/init --version | grep -ic "SysV") -eq 1 ]; then
					#~ echo "sysvinit primary init detected...  executing runlevel command..."
					/usr/lib/sysvinit/runlevel $@;
					exit 0
				elif [ $(ps -p1 | grep -ic "systemd") -eq 1 ]; then
					#~ echo "systemd primary init detected...  executing runlevel command..."
					/usr/lib/systemd/runlevel $@;
					exit 0
				else 
					echo "Strange... Cannot detect primary init...  Will try to execute runlevel using bysybox... executing runlevel command..."
					sync && sleep 5 && /usr/bin/busybox runlevel -f;
					exit 1
				fi
		else
			#~ echo "cmdline init booted... detecting init"
				if [ $(ps -p1 | grep -ic "runit") -eq 1 ]; then
					#~ echo "runit cmdline init detected...  executing runlevel command..."
					/usr/lib/runit/runlevel $@;
					exit 0
				elif [ $(ps -p1 | grep -ic "s6-svscan") -eq 1 ] && [ -e /run/s6-rc ]; then
					echo "s6-rc cmdline init detected...  Runlevels are not relevant for s6-rc..."
					exit 0
				elif [ $(ps -p1 | grep -ic "s6-svscan") -eq 1 ] && [ -e /run/66 ]; then
					echo "s6-66 cmdline init detected...  Runlevels are not relevant for s6-66..."
					exit 0
				elif [ $(ps -p1 | grep -ic "openrc") -eq 1 ]; then
					#~ echo "openrc cmdline init detected...  executing runlevel command..."
					rc-status -r $@;
					exit 0
				elif [ $(ps -p1 | grep -ic "dinit") -eq 1 ] || [ $(cat /proc/cmdline | grep -ic "dinit") -eq 1 ]; then
					echo "dinit cmdline init detected...  Runlevels are not relevant for dinit..."
					exit 0
				elif [ $(ps -p1 | grep -ic "init") -eq 1 ] && [ $(cat /proc/cmdline | grep -ic "sysvinit") -eq 1 ]; then
					#~ echo "sysvinit cmdline init detected...  executing runlevel command..."
					/usr/lib/sysvinit/runlevel $@;
					exit 0
				elif [ $(ps -p1 | grep -ic "systemd") -eq 1 ]; then
					#~ echo "systemd cmdline init detected...  executing runlevel command..."
					/usr/lib/systemd/runlevel $@;
					exit 0
				else 
					echo "Strange... Cannot detect cmdline init...  Will try to execute runlevel using bysybox... executing runlevel command..."
					sync && sleep 5 && /usr/bin/busybox runlevel -f;
					exit 1
				fi	
		fi
	
fi



