#!/bin/bash

[ "$UID" -eq 0 ] || exec sudo bash "$0" "$@"

if [ "$(id -u)" -gt 0 ]; then
	echo "shutdown needs to be run as root or using sudo"
	exit 1
elif [[ $(ps -p1 | grep -ic "s6-svscan") -eq 1 && -e /run/s6-rc ]]; then
		sync && s6-linux-init-shutdown $@;
elif [[ $(ps -p1 | grep -ic "s6-svscan") -eq 1 && -e /run/66 ]]; then
		sync && 66-shutdown $@;
elif [[ $(ps -p1 | grep -ic "runit") -eq 1 ]]; then
		sync && touch /run/initctl && /usr/lib/runit/shutdown $@;
elif [[ $(ps -p1 | grep -ic "openrc") -eq 1 ]] || ( [[ $(ps -p1 | grep -ic "init") -eq 1 ]] && [[ $(init --version | grep -ic "SysV" ) -eq 0 ]] && [[ $(init --version | grep -ic "Dinit" ) -eq 0 ]] ); then
		sync && ( /usr/lib/openrc/openrc-shutdown $@ | /usr/sbin/openrc-shutdown $@ );
elif [[ $(ps -p1 | grep -ic "dinit") -eq 1 ]] || ( [[ $(ps -p1 | grep -ic "init") -eq 1 ]] && [[ $(init --version | grep -ic "Dinit") -eq 1 ]] ); then
		sync && ( /usr/lib/dinit/shutdown $@ | /usr/sbin/shutdown $@ );
elif [[ $(ps -p1 | grep -ic "init") -eq 1 ]] && [[ $(init --version | grep -ic "SysV") -eq 1 ]]; then
		sync && ( /usr/lib/sysvinit/shutdown $@ | /usr/sbin/shutdown $@ );
elif [[ $(ps -p1 | grep -ic "systemd") -eq 1 ]]; then
		/usr/lib/systemd/systemd-shutdown $@;
else sync && touch /run/initctl && ( /sbin/shutdown $@ >/dev/null 2>&1 | s6-linux-init-shutdown $@ >/dev/null 2>&1 | 66-shutdown $@ >/dev/null 2>&1 | /lib/runit/shutdown $@ >/dev/null 2>&1 | /lib/openrc/openrc-shutdown $@ >/dev/null 2>&1 | /lib/dinit/shutdown $@ >/dev/null 2>&1 | /lib/sysvinit/shutdown $@ >/dev/null 2>&1 | /lib/systemd/systemd-shutdown $@ >/dev/null 2>&1 )

fi
